/**
 * AmbientTalk/2 Project
 * ATMessageCreation.java created on 26-jul-2006 at 15:08:00
 * (c) Programming Technology Lab, 2006 - 2007
 * Authors: Tom Van Cutsem & Stijn Mostinckx
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
package edu.vub.at.objects.grammar;

import edu.vub.at.objects.ATTable;

/**
 * The public interface to a first-class message AG element.
 * An ATMessageCreation may represent synchronous, asynchronous or delegation messages.
 * An abstract message at least contains a selector, arguments and annotations (type tags)
 * 
 * @author tvcutsem
 */
public interface ATMessageCreation extends ATExpression {
	
    /**
     * Messages always have a selector, a symbol denoting the field or method that
     * needs to be sought for.
     * Example: <code>`(<-m()).selector == `m</code>
     * @return a symbol denoting the selector
     */
	public ATSymbol base_selector();
	
	/**
     * Messages may optionally have arguments if they represent invocations.
     * Splicing is allowed in the argument list
     * Example: <code>`(<-m(a, @b)).arguments == `[a, @b]</code>
     * @return the arguments passed to the invocation
     */
	public ATTable base_arguments();
	
	/**
	 * Messages may optionally have annotations (type tags)
	 * @return the annotations of the message
	 */
	public ATExpression base_annotations();

}
